/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/** 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 11, 2003
 * Title : JavaBean.XmlUnmarshal.java
 * Desprition : This JavaBean class is responsible for processing request initiated 
 * from the related jsp pages and validating the inputs by using classes Validator.*
 * 
 */

/**Imported classes and packages */
package XmlCommunication;
import java.io.*;
import java.util.*;
import org.exolab.castor.xml.Unmarshaller;
import nz.co.cks.tms.xml.*;
import DataClasses.*;

/**
 * @author student
 *
 * This class is being used for interpreting the response xml packets 
 * from TMS.
 * 
 */
public class XmlUnmarshal {

	private static ResponseGeneral rg;
	private static ResponseNcb rn;
	private static ResponseEnquiryNcbAddress rena;
	private static ResponseReport rr;
	private static ResponseEnquiryNcbService rens;
	private static ResponseEnquiryItem rei;

	private static int ncbId;
	private static String response = "";

	/**
	 * This method is being used for classifying the type of 
	 * response and directing to the appropriate method for
	 * processing.
	 * @param input The input xml string to be interpreted.
	 * @return String The interpretation of the xml string.
	 */
	public String readResponse(String input) {
		try {
			rg = null;
			rn = null;
			rena = null;
			rr = null;
			rens = null;
			rei = null;

			StringReader reader = new StringReader(input);

			Unmarshaller unmarshaller = new Unmarshaller(TmsMessage.class);

			//Unmarshal the xml object
			TmsMessage tmsMessage = (TmsMessage) unmarshaller.unmarshal(reader);
			MessageAuthBlk mab = tmsMessage.getMessageAuthBlk();
			MessageTypeChoice mtc = tmsMessage.getMessageTypeChoice();
			MessageResponseBlk mrb = mtc.getMessageResponseBlk();
			ResponseGeneral[] arr = mrb.getResponseGeneral();
			if (arr.length > 0) {
				XmlUnmarshal.rg = arr[0];
				response = responseGeneral(rg);
				System.out.println("Its a response General! ");
			}
			rn = mrb.getResponseNcb();
			if (rn != null) {
				response = responseNcb(rn);
				System.out.println("Its a response Ncb! ");
			}
			rr = mrb.getResponseReport();
			if (rr != null) {
				response = responseReport(rr);
				System.out.println("Its a response Enquiry Ncb Address! ");
			}
			rens = mrb.getResponseEnquiryNcbService();
			if (rens != null) {
				response = responseEnquiryNcbService(rens);
				System.out.println("Its a response Enquiry Ncb Service! ");
			}
			rena = mrb.getResponseEnquiryNcbAddress();
			if (rena != null) {
				response = responseEnquiryNcbAddress(rena);
				System.out.println("Its a response Enquiry Ncb Address! ");
			}

			rei = mrb.getResponseEnquiryItem();
			if (rei != null) {
				response = responseEnquiryItem(rei);
				System.out.println("Its a response Enquiry Ncb Address! ");
			}

			System.out.println("Unmarshal read Response Finished...");
			return response;
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return response;
		}

	}
	/**
	 * This method is being used for getting all the attributes
	 * of an xml packet which is of type ncb service response.
	 * @param input The xml string to be interpreted.
	 * @return String The interpretation of the xml string.
	 */
	public String readNcbServiceResponse(String input) {

		try {

			StringReader reader = new StringReader(input);
			System.out.println("Unmarshal read ServiceResponse Started...");
			System.out.println("****INPUT XML INTO UNMARSHAL****");
			System.out.println(input);

			Unmarshaller unmarshaller =
				new Unmarshaller(TmsNcbServiceAuth.class);

			//Unmarshal the xml object
			TmsNcbServiceAuth tmsNcbServiceAuth =
				(TmsNcbServiceAuth) unmarshaller.unmarshal(reader);

			NcbService[] mab = tmsNcbServiceAuth.getNcbService();

			int ncbId = tmsNcbServiceAuth.getNcbId();
			int limit = tmsNcbServiceAuth.getNcbConnectionLimit();
			Date date = tmsNcbServiceAuth.getNcbServiceAuthDateTime();
			String comment = tmsNcbServiceAuth.getNcbServiceAuthComment();

			response = String.valueOf(ncbId);
			return response;

		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			response += "EXCEPTION! : " + e.toString();
			return response;
		}

	}
	/**
	 * This method is being used for getting all the attributes
	 * of an xml packet which is of type response general.
	 * @param rg Response General to be interpreted.
	 * @return String The interpretation of the response general.
	 */
	public String responseGeneral(ResponseGeneral rg) {
		String s = "";
		if (Integer.parseInt(rg.getCode()) != 0) {
			s =
				"The request was not processed because : "
					+ rg.getDescription();
			if (Integer.parseInt(rg.getCode()) == 9) {
				response =
					"The user name is already registered. Please choose a different user name and try again";
			}
		} else {
			s =
				"The request was processed successfully: "
					+ rg.getDescription();
		}
		//			System.out.println("Response General Code: "+rg.getCode());
		//			System.out.println("Response General Action String: "+rg.getActionString());
		//			
		//			System.out.println("Response General Description: "+rg.getDescription());
		//			System.out.println("Response General DateTime: "+rg.getResponseDateTime());
		//			System.out.println("Response General ExpiryDateTime: "+rg.getResponseExpiryDateTime());
		return s;

	}
	/**
	 * This method is being used for getting all the attributes
	 * of an xml packet which is of type response ncb.
	 * @param rn ResponseNcb to be interpreted.
	 * @return String The interpretation of the response ncb.
	 */
	public String responseNcb(ResponseNcb rn) {
		Ncb ncb = rn.getNcb(0);
		ncbId = ncb.getNcbId();
		return "The ncbId :" + ncbId;
	}
	/**
	 * This method is being used for getting all the attributes
	 * of an xml packet which is of type response report.
	 * @param rr Response Report that is to be interpreted.
	 * @return String The interpretation of the response report.
	 */
	public String responseReport(ResponseReport rr) {
		String report = rr.getReportOutput();
		return "ResponseReport output is :" + report;
	}
	/**
	 * This method is being used for getting all the attributes
	 * of an xml packet which is of type response enquiry ncb
	 * service.
	 * @param rens ResponseEnquiryNcbService to be interpreted.
	 * @return String The interpretation of ResponseEnquiryNcbService. 
	 */
	public String responseEnquiryNcbService(ResponseEnquiryNcbService rens) {
		int ncbId = rens.getNcbId();
		NcbService[] ncbService = rens.getNcbService();
		String service = ncbService.toString();
		return "Response Enquiry ncb Service :" + ncbId + " " + service;
	}
	/**
	 * This method is being used for getting all the attributes
	 * of an xml packet which is of type response enquiry ncb
	 * address.
	 * @param rn The responseEnquiryNcbAddress to be interpreted. 
	 * @return String The interpretation of responseEnquiryNcbAddress.
	 */
	public String responseEnquiryNcbAddress(ResponseEnquiryNcbAddress rn) {
		return "Response Enquiry ncb Address :" + ncbId;
	}
	/**
	 * This method is being used for getting all the attributes
	 * of an xml packet which is of type response enquiry item.
	 * @param rei ResponseEnquiryItem to be interpreted.
	 * @return String The interpretation of ResponseEnquiryItem.
	 */
	public String responseEnquiryItem(ResponseEnquiryItem rei) {
		ItemCost[] itemCost = rei.getItemCost();
		String cost = itemCost.toString();
		int ncbId = rei.getNcbId();
		String service = rei.getServiceCode();
		return "Response Enquiry Item :" + ncbId + " " + cost + " " + service;
	}

	
	/********Helper Methods**********/
	/**
	 * This utility method is being used for getting the response general code
	 * from TMS.
	 * @return String The response general code returned by TMS.
	 */
	public String getResponseGeneralCode() {
		if (rg != null) {
			return rg.getCode();
		} else {
			return "0";
		}
	}
	/**
	 * This method is being used for getting the response general description
	 * from TMS.
	 * @return String The response general description.
	 */
	public String getResponseGeneralDescription() {
		if (rg != null) {
			return rg.getDescription();
		} else {
			return "Not response General.";
		}
	}
	/**
	 * This method is being used for getting the ncb id field.
	 * @return int The Ncb Id. 
	 */
	public int getNcbId() {
		return ncbId;
	}
	/**
	 * This method is being used for getting the customer details
	 * from TMS.
	 * @param user The updated user details. 
	 * @return void
	 */
	public void getUser(User_Data user) {
		if (rn != null) {
			if (user.getType().equals("Person")) {
				user.setFirstName(rn.getNcb(0).getName());
				user.setLastName(rn.getNcb(0).getNameLast());
			} else {
				user.setOrganisation(rn.getNcb(0).getName());
			}
			user.setUserName(rn.getNcb(0).getLogin());
			//user.setPassword(rn.getNcb(0).getPassword());					
		}
	}

	/**
	 * This method is being used for getting the address details
	 * from TMS.
	 * @param address The updated address details.
	 * @return void
	 */
	public void getAddress(UserAddress_Data address) {
		if (rena != null) {
			address.setCity(rena.getNcbAddress(0).getCity());
			address.setEmail(rena.getNcbAddress(0).getEmail());
			address.setPhone(rena.getNcbAddress(0).getPhoneNumber());
			address.setStreet(rena.getNcbAddress(0).getStreetLine1());
			address.setSuburb(rena.getNcbAddress(0).getStreetLine2());
			address.setCountry(rena.getNcbAddress(0).getStreetLine3());

		}
	}

	/**
	 * This method is being used for getting the response message.
	 * @return String
	 */
	public String getResponse() {
		return response;
	}

}
